#include <GL/glut.h>
#include "trackball.h"
#include "trackball.c"

GLfloat m[4][4];		
float last[4];
float cur[4]; 
int width; 
int height;
int beginx;
int beginy;
float p1x; 
float p1y; 
float p2x; 
float p2y;

void display()
{
  glPushMatrix();
  build_rotmatrix(m, cur);  
  glLoadIdentity();
  glMultMatrixf(*m);
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glutSolidTeapot(0.5); 
  glPopMatrix();
  glutSwapBuffers();
}

void mouse(int button,int state, int x, int y)   
{
  beginx = x;
  beginy = y;
}

void motion(int x,int y)   
{
  p1x = (2.0*beginx - width)/width;
  p1y = (height - 2.0*beginy)/height;
  p2x = (2.0 * x - width) / width;
  p2y = (height - 2.0 * y) / height;
  trackball(last,p1x, p1y, p2x, p2y);   
  add_quats(last, cur, cur);   
  beginx = x;
  beginy = y;
  glutPostRedisplay();   
}

void reshape (int w, int h)
{
  width=w;
  height=h;
  double l;
  l = 1;
  glViewport (0, 0, w, h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity();
  glOrtho(-l, l, -l, l, -l, l);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}


int main(int argc, char *argv[])
{
  glutInit(&argc, argv);
  trackball(cur, 0.0, 0.0, 0.0, 0.0);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
  glutCreateWindow("Rotacija z misko");
  glutDisplayFunc(display);
  glutMouseFunc(mouse);
  glutMotionFunc(motion);
  glutReshapeFunc(reshape);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glEnable(GL_DEPTH_TEST);
  glutMainLoop();
  return 0;
}
